import * as React from "react";

import { PendingEmoticonSubmit } from "aegis/features/emotes/components/pending-emoticon-submit";
import { EmoticonApprovalPartnerFilter } from "aegis/features/emotes/models";
import { CoreText, Display, FormGroup, JustifyContent, Layout, Select, TextType } from "twitch-core-ui";

import "./styles.scss";

export const ALL_BUCKET = "ALL";
export const DEFAULT_BUCKET_COUNT = 3;
export const ALL_BUCKET_STATE = {
  bucketCount: 1,
  currentBucket: 0
};
export const DEFAULT_BUCKET_STATE = {
  currentBucket: 0,
  bucketCount: 3
};

export interface PublicProps {}

interface State {
  currentBucket: number;
  bucketCount: number;
  partnerFilter: EmoticonApprovalPartnerFilter;
}

class PendingEmoticonsComponent extends React.Component<PublicProps, State> {
  public state: State = {
    ...DEFAULT_BUCKET_STATE,
    partnerFilter: EmoticonApprovalPartnerFilter.All
  };

  public render() {
    return (
      <Layout padding={2}>
        <CoreText type={TextType.H2}>Emoticons</CoreText>
        <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
          <Layout display={Display.Flex} padding={{ y: 1 }}>
            <Layout className="emoticon-approval__select" margin={{ right: 1 }}>
              <FormGroup label="Bucket">
                <Select onChange={this.onBucketChange}>
                  <option value={0}>Bucket 1</option>
                  <option value={1}>Bucket 2</option>
                  <option value={2}>Bucket 3</option>
                  <option value={ALL_BUCKET}>All</option>
                </Select>
              </FormGroup>
            </Layout>
            <Layout className="emoticon-approval__select" margin={{ right: 1 }}>
              <FormGroup label="Filter">
                <Select onChange={this.onFilterChange}>
                  <option value={EmoticonApprovalPartnerFilter.All}>All</option>
                  <option value={EmoticonApprovalPartnerFilter.Partner}>Partner</option>
                  <option value={EmoticonApprovalPartnerFilter.Affiliate}>Affiliate</option>
                </Select>
              </FormGroup>
            </Layout>
          </Layout>
        </Layout>
        <PendingEmoticonSubmit
          currentBucket={this.state.currentBucket}
          bucketCount={this.state.bucketCount}
          partnerFilter={this.state.partnerFilter}
        />
      </Layout>
    );
  }

  private onBucketChange = (e: React.FormEvent<HTMLSelectElement>) => {
    this.setState(getBucketState(e.currentTarget.value));
  };

  private onFilterChange = (e: React.FormEvent<HTMLSelectElement>) => {
    const val: EmoticonApprovalPartnerFilter = e.currentTarget.value as EmoticonApprovalPartnerFilter;
    this.setState({
      partnerFilter: val
    });
  };
}

/**
 * getBucketState takes in the selected bucket value and returns the proper state.
 * This function checks for the ALL_BUCKET value and returns the ALL_BUCKET_STATE constant which forces
 * the bucketCount to 1 and the currentBucket to 0. Otherwise it parses selectValue into an int which is used
 * as the currentBucket value and sets the bucketCount to DEFAULT_BUCKET_COUNT.
 * @param selectValue A string containing the bucket <option> value
 */
export function getBucketState(selectValue: string): Pick<State, "currentBucket" | "bucketCount"> {
  if (selectValue === ALL_BUCKET) {
    return ALL_BUCKET_STATE;
  }

  const val: number = Number(selectValue);
  if (!isNaN(val)) {
    return {
      currentBucket: val,
      bucketCount: DEFAULT_BUCKET_COUNT
    };
  }

  return DEFAULT_BUCKET_STATE;
}

export const PendingEmoticons: React.ComponentClass<PublicProps> = PendingEmoticonsComponent;
