export enum DeclineReason {
  Duplicate = "Duplicate",
  DrugsOrDrugParaphernalia = "DrugsOrDrugParaphernalia",
  Genitalia = "Genitalia",
  Harassment = "Harassment",
  HateSpeech = "HateSpeech",
  ImageSize = "ImageSize",
  PoliticalImagery = "PoliticalImagery",
  PII = "PII",
  SexualContent = "SexualContent",
  SingleLetter = "SingleLetter",
  GlobalEmoteDerivative = "GlobalEmoteDerivative",
  ViolenceOrGore = "ViolenceOrGore",
  OtherInappropriateContent = "OtherInappropriateContent"
}

export const declineReasons = new Map<DeclineReason, { title: string; message: string }>([
  [
    DeclineReason.Duplicate,
    {
      title: "Accidental duplicate emote submission",
      message: `The name or image of this emote is a duplicate submission.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.DrugsOrDrugParaphernalia,
    {
      title: "Drugs or Drug Paraphernalia",
      message: `Disallowed content - Imagery of drugs or drug paraphernalia.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.Genitalia,
    {
      title: "Genitalia",
      message: `Disallowed content - Imagery of genitalia.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.Harassment,
    {
      title: "Harassment",
      message: `Disallowed content - Targeted insults, bullying, and threatening or inciting abuse.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.HateSpeech,
    {
      title: "Hate speech or hateful imagery",
      message: `Disallowed content - Hate speech, including offensive slang, symbols, stereotypes, and imagery.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.ImageSize,
    {
      title: "Not all sizes submitted are the same image",
      message: `All emote sizes must be of the same image.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],

  [
    DeclineReason.PoliticalImagery,
    {
      title: "Political imagery",
      message: `Disallowed content - Political images.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.PII,
    {
      title: "Revealing PII via Emote Upload",
      message: `Disallowed content - Personal Identifiable information in the emote submission.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.SexualContent,
    {
      title: "Sexual content or nudity",
      message: `Disallowed content - Imagery of sexual content or nudity. i.e. “Gasm”-style emotes which contain sexualized torsos or bodily fluids.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.SingleLetter,
    {
      title: "Single Letter Emotes",
      message: `Disallowed content - Single letter emote.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.GlobalEmoteDerivative,
    {
      title: "Unauthorized global emote derivatives and brand assets",
      message: `Disallowed content - No emotes based on Twitch Global Emoticons or Twitch Intellectual Property. The only exceptions to this are Kappa and VoHiYo derivatives, which are allowed with certain restrictions. Kappa derivatives are permitted (a maximum of two Kappa derivatives per channel are allowed) with the exception of those including only minimal design changes such as recoloring. VoHiYo derivatives may not use or appear to use original assets.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.ViolenceOrGore,
    {
      title: "Violence or gore",
      message: `Disallowed content - Obscene content such as extreme or gratuitous depictions of violence, blood, gore, severe injury, and death.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ],
  [
    DeclineReason.OtherInappropriateContent,
    {
      title: "Other Inappropriate Content",
      message: `Disallowed content - Generally inappropriate content.

For more info, please refer to our Emoticon Guide: https://link.twitch.tv/EmoticonGuide_ReviewEmail`
    }
  ]
]);
