import { EmoticonInfo, EmoticonStatus, PendingEmoticonsResponse } from "aegis/features/emotes/models";
import { UserRole } from "aegis/models";

export function mockEmoticonInfo(count?: number): EmoticonInfo[] {
  let mockData = [
    {
      id: "522778",
      owner: "tww2",
      code: "Sad",
      isPartner: true,
      regex: "twwSad",
      status: EmoticonStatus.Pending,
      img28Src: `https://static-cdn.jtvnw.net/emoticons/v1/522778/1.0`,
      img56Src: `https://static-cdn.jtvnw.net/emoticons/v1/522778/2.0`,
      img112Src: `https://static-cdn.jtvnw.net/emoticons/v1/522778/3.0`,
      createdOn: new Date("2018-04-27T20:08:37.640Z")
    },
    {
      id: "191492",
      owner: "mr_woodchuck",
      code: "Think",
      isPartner: false,
      regex: "chuckThink",
      status: EmoticonStatus.Pending,
      img28Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/1.0`,
      img56Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/2.0`,
      img112Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/3.0`,
      createdOn: new Date("2018-04-29T20:09:43.681Z")
    },
    {
      id: "191492",
      owner: "mr_woodchuck",
      code: "Think",
      isPartner: false,
      regex: "chuckThink",
      status: EmoticonStatus.Pending,
      img28Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/1.0`,
      img56Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/2.0`,
      img112Src: `https://static-cdn.jtvnw.net/emoticons/v1/191492/3.0`,
      createdOn: new Date("2018-04-29T20:09:43.681Z")
    }
  ];
  if (count) {
    mockData = mockData.slice(0, count);
  }
  return mockData;
}

export function mockPendingEmoticonsResponse(count?: number): PendingEmoticonsResponse {
  let mockData = [
    {
      cursor: "522778",
      node: {
        id: "522778",
        owner: {
          id: "13405587",
          login: "tww2",
          roles: [UserRole.Staff, UserRole.Partner]
        },
        prefix: "tww",
        code: "Sad",
        uploadTime: "2018-04-27T20:08:37.640Z",
        isPartner: true
      }
    },
    {
      cursor: "191492",
      node: {
        id: "191492",
        owner: {
          id: "89614178",
          login: "mr_woodchuck",
          roles: [UserRole.Staff, UserRole.Affiliate]
        },
        prefix: "chuck",
        code: "Think",
        uploadTime: "2018-04-29T20:09:43.681Z",
        isPartner: true
      }
    },
    {
      cursor: "95118",
      node: {
        id: "95118",
        owner: {
          id: "13405587",
          login: "tww2",
          roles: [UserRole.Staff, UserRole.Partner]
        },
        prefix: "tww",
        code: "Happy",
        uploadTime: "2018-05-01T20:09:43.681Z",
        isPartner: false
      }
    }
  ];
  if (count) {
    mockData = mockData.slice(0, count);
  }
  return {
    pendingEmoticons: {
      edges: mockData
    }
  };
}
