import { UserRole } from "aegis/models";
export enum EmoticonStatus {
  Pending = "Pending",
  Approved = "Approved",
  Deferred = "Deferred",
  Declined = "Declined"
}

export enum EmoticonApprovalError {
  RequestError,
  MissingRejectReason,
  None
}

export enum EmoticonApprovalPartnerFilter {
  All = "all",
  Partner = "partner",
  Affiliate = "affiliate"
}

export interface EmoticonInfo {
  id: string;
  owner: string;
  code: string;
  isPartner: boolean;
  regex: string;
  status: EmoticonStatus;
  img28Src: string;
  img56Src: string;
  img112Src: string;
  createdOn: Date;
}

export interface EmoticonAction {
  emoticonID: string;
  action: EmoteActionOption;
  reason: string;
  detailedReason: string;
}

export enum EmoteActionOption {
  APPROVE = "Approve",
  DEFER = "Defer",
  DECLINE = "Decline"
}

export interface ReviewEmoticonsMutationInput {
  input: {
    reviews: EmoticonAction[];
  };
}

export interface PendingEmoticonsResponse {
  pendingEmoticons: {
    edges: {
      cursor: string;
      node: PendingEmoticonNode;
    }[];
  };
}

export interface PendingEmoticonNode {
  id: string;
  owner: {
    id: string;
    login: string;
    roles: UserRole[];
  };
  prefix: string;
  code: string;
  uploadTime: string;
}
