import * as React from "react";

import { Enforcement } from "aegis/models";
import { OffsetPageInfo } from "aegis/models/offset_pageinfo";
import { Layout, Pagination, PaginationMouseEvent } from "twitch-core-ui";
import { EnforcementResults } from "./components/enforcement-results";
import { ENFORCEMENTS_PER_PAGE } from "./container";

export interface Props {
  enforcements: Enforcement[];
  getEnforcementsForPage: (pageNumber: number) => void;
  pageInfo: OffsetPageInfo;
}

export class EnforcementComponent extends React.Component<Props> {
  public render() {
    const { enforcements, getEnforcementsForPage, pageInfo } = this.props;
    const currentPage = pageInfo.offset / ENFORCEMENTS_PER_PAGE + 1;
    const totalPages = Math.ceil(pageInfo.total / ENFORCEMENTS_PER_PAGE);
    return (
      <Layout>
        <EnforcementResults enforcements={enforcements} total={pageInfo.total} />
        <Layout margin={{ left: 1, top: 2, bottom: 2 }}>
          <Pagination
            currentPage={currentPage}
            totalPages={totalPages}
            onClickIndex={(e: PaginationMouseEvent<HTMLDivElement>): void => {
              getEnforcementsForPage(e.goToPage);
            }}
            onClickNext={() => getEnforcementsForPage(currentPage + 1)}
            onClickPrevious={() => getEnforcementsForPage(currentPage - 1)}
            nextPageButtonAriaLabel="Next Page"
            previousPageButtonAriaLabel="Previous Page"
          />
        </Layout>
      </Layout>
    );
  }
}
