import * as React from "react";

import { Color, CoreText, Display, FlexDirection, Layout, TextType } from "twitch-core-ui";

export interface RowProps {
  label?: boolean;
}

export interface ColumnProps {
  header?: string;
}

export const EnforcementRow: React.SFC<RowProps> = ({ label, children }) => {
  return (
    <Layout margin={{ y: 0.5 }}>
      <CoreText color={label ? Color.Alt2 : Color.Base}>{children}</CoreText>
    </Layout>
  );
};

export const EnforcementColumn: React.SFC<ColumnProps> = ({ header, children }) => {
  const headerElements = (
    <Layout margin={{ bottom: 0.5, top: 1 }}>
      <CoreText type={TextType.H5}>{header}</CoreText>
    </Layout>
  );
  return (
    <Layout margin={{ x: 2 }}>
      {header ? headerElements : ""}
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
        {children}
      </Layout>
    </Layout>
  );
};
