import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Description, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("EnforcementDescription", () => {
  it("Renders", () => {
    const wrapper = Enzyme.mount(<Description description="Mock description" id="1" />);
    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.showMore }).exists()).toBeFalsy();
  });
  it("Renders with a show more button", () => {
    const wrapper = Enzyme.mount(
      <Description
        description={`
      Mock
      description
      has
      multiple
      lines
      of
      of
      of
      of
      of
      of
      of
      of
      text`}
        id="1"
      />
    );
    // This is a hack. Enzyme does not give back offsetHeight and scrollHeight
    // this sets the state to confirm that show more button still renders.
    wrapper.setState({ showFullText: false, needShowMoreButton: true });

    expect(wrapper).toBeTruthy();
    expect(wrapper.find({ "data-test-selector": TestSelectors.showMore }).exists()).toBeTruthy();
  });
});
