import * as React from "react";
import { CoreLink, CoreText, Layout, StyledLayout, TextType } from "twitch-core-ui";

import "./styles.scss";

interface Props {
  id: string;
  description: string;
}

interface State {
  showFullText: boolean;
  needShowMoreButton: boolean;
}
export enum TestSelectors {
  showMore = "enforcement-description-show-more"
}

export class Description extends React.Component<Props, State> {
  constructor(props: Props) {
    super(props);

    this.state = {
      showFullText: false,
      needShowMoreButton: false
    };
  }

  public componentDidMount() {
    const descriptionDiv = document.getElementById(this.descriptionID);
    const fullTextDisplayed = !!descriptionDiv && descriptionDiv.offsetHeight < descriptionDiv.scrollHeight;

    this.setState({
      showFullText: !fullTextDisplayed,
      needShowMoreButton: fullTextDisplayed
    });
  }

  public render() {
    const { description } = this.props;
    return (
      <Layout>
        <Layout margin={{ bottom: 1 }}>
          <CoreText type={TextType.H5}>Description</CoreText>
        </Layout>
        <StyledLayout borderBottom />
        <div id={this.descriptionID} className="enforcement-search__description">
          <Layout
            className={
              this.state.showFullText ? "enforcement-search__description-full" : "enforcement-search__description-short"
            }
          >
            <p>{description}</p>
          </Layout>
        </div>
        {this.state.needShowMoreButton && (
          <CoreLink
            data-track-click="enforcement-search-description-show-more"
            data-test-selector={TestSelectors.showMore}
            onClick={() =>
              this.setState({
                showFullText: !this.state.showFullText
              })
            }
          >
            {this.state.showFullText ? "Show less" : "Show more"}
          </CoreLink>
        )}
      </Layout>
    );
  }
  private get descriptionID() {
    return `enforcement-search__description-${this.props.id}`;
  }
}
