import * as React from "react";

import { CoreLink, CoreText, Display, FlexDirection, JustifyContent, Layout, StyledLayout } from "twitch-core-ui";

import { UserCardLink } from "aegis/features/user-card/user-link";
import { UserRoleTags } from "aegis/features/user-role-tags";
import { Enforcement, UserRole } from "aegis/models";
import { EnforcementColumn, EnforcementRow } from "../component";
import { Description } from "../description";

export interface WarningProps {
  enforcement: Enforcement;
  roles?: UserRole[];
}

export const EnforcementWarningBody: React.SFC<WarningProps> = ({ enforcement, roles }) => {
  return (
    <StyledLayout>
      <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
        <EnforcementColumn header="Enforcement Metadata">
          <StyledLayout borderBottom flexGrow={1} />
          <Layout display={Display.Flex}>
            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow label>warning ID</EnforcementRow>
              <EnforcementRow label>User</EnforcementRow>
              <EnforcementRow label>From</EnforcementRow>
              <EnforcementRow label>Created at</EnforcementRow>
              <EnforcementRow label>Updated at</EnforcementRow>
            </Layout>
            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow>{enforcement.id}</EnforcementRow>
              <Layout margin={{ y: 0.5 }}>
                <UserCardLink userID={enforcement.targetUserID}>
                  <CoreLink>
                    <CoreText>
                      {!!enforcement.suspension ? enforcement.suspension.targetUserUsername : ""} [{
                        enforcement.targetUserID
                      }]
                    </CoreText>
                  </CoreLink>
                </UserCardLink>
                <UserRoleTags roles={roles} />
              </Layout>
              <EnforcementRow>{enforcement.fromUserID}</EnforcementRow>
              <EnforcementRow>{new Date(enforcement.createdAt).toDisplayFormat()}</EnforcementRow>
              <EnforcementRow>{new Date(enforcement.updatedAt).toDisplayFormat()}</EnforcementRow>
            </Layout>
          </Layout>
        </EnforcementColumn>
        <EnforcementColumn header="Violation Details">
          <StyledLayout borderBottom flexGrow={1} />
          <Layout display={Display.Flex}>
            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow label>Content</EnforcementRow>
              <EnforcementRow label>Reason</EnforcementRow>
              <EnforcementRow label>Detailed Reason</EnforcementRow>
            </Layout>

            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow>{enforcement.content}</EnforcementRow>
              <EnforcementRow>{enforcement.reason}</EnforcementRow>
              <EnforcementRow>{enforcement.detailedReason}</EnforcementRow>
            </Layout>
          </Layout>
        </EnforcementColumn>
        <EnforcementColumn header="Punishment Details">
          <StyledLayout borderBottom flexGrow={1} />
          <Layout display={Display.Flex}>
            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow label>Duration</EnforcementRow>
              <EnforcementRow label>IP Ban</EnforcementRow>
              <EnforcementRow label>Cleared channel images</EnforcementRow>
            </Layout>

            <Layout display={Display.Flex} flexDirection={FlexDirection.Column} margin={{ right: 2 }}>
              <EnforcementRow>warning</EnforcementRow>
              <EnforcementRow>false</EnforcementRow>
              <EnforcementRow>
                {!!enforcement.warning && enforcement.warning.clearedChannelImages !== null
                  ? enforcement.warning.clearedChannelImages.valueOf().toString()
                  : "false"}
              </EnforcementRow>
            </Layout>
          </Layout>
        </EnforcementColumn>
      </Layout>
      <Layout margin={{ y: 2, x: 2 }}>
        <Description
          id={enforcement.id}
          description={
            !!enforcement.warning && !!enforcement.warning.description
              ? enforcement.warning.description
              : enforcement.description
          }
        />
      </Layout>
    </StyledLayout>
  );
};
