import * as React from "react";

import gql from "graphql-tag";

import { Query } from "aegis/functionality/apollo-wrapper";
import { Enforcement, UserRole } from "aegis/models";
import { Color, CoreText, Placeholder } from "twitch-core-ui";
import { EnforcementCardComponent, PublicProps } from "./component";

export type Response = {
  user: {
    profileImage: string;
    roles: UserRole[];
  };
};

export const FETCH_USER_ENFORCEMENT_DATA = gql`
  query userProfileImage($id: ID) {
    user(id: $id) {
      id
      profileImage
      roles
    }
  }
`;
export interface ContainerProps {
  enforcement: Enforcement;
}

export interface InputProps {
  id: string;
}

export class UserProfileImageQuery extends Query<Response, InputProps> {}

export class EnforcementCard extends React.Component<ContainerProps & PublicProps> {
  public render() {
    const { enforcement } = this.props;
    return (
      <UserProfileImageQuery
        displayName="EnforcementCard"
        query={FETCH_USER_ENFORCEMENT_DATA}
        variables={{ id: enforcement.targetUserID }}
      >
        {({ loading, error, data }) => {
          if (loading) {
            return <Placeholder width={1500} />;
          }
          if (error) {
            console.error(error);
            return <CoreText color={Color.Error}>Error: {error.message}</CoreText>;
          }
          if (!data || !data.user || !data.user.profileImage) {
            return <EnforcementCardComponent {...this.props} roles={data && data.user.roles} />;
          } else {
            return (
              <EnforcementCardComponent
                {...this.props}
                userProfileImage={data.user.profileImage}
                roles={data && data.user.roles}
              />
            );
          }
        }}
      </UserProfileImageQuery>
    );
  }
}
