import * as React from "react";

import { formatDurationTimestamp } from "aegis/features/report-view/components/report-body/stream-embed/component";
import { AlignItems, Avatar, Color, CoreText, Display, Icon, Layout, StyledLayout, SVGAsset } from "twitch-core-ui";

export interface Props {
  open?: boolean;
  duration?: number;
  targetUserName: string;
  createdAt: string;
  profileImage?: string;
  content?: string;
  reason?: string;
}

export const EnforcementHeader: React.SFC<Props> = ({
  open,
  duration,
  targetUserName,
  createdAt,
  profileImage,
  content,
  reason
}) => {
  const lengthElement = (
    <Layout margin={{ x: 1 }} className="enforcement-header">
      <CoreText color={Color.Alt2}>{duration ? formatDurationTimestamp(duration) : ""}</CoreText>
    </Layout>
  );
  return (
    <StyledLayout display={Display.Flex} alignItems={AlignItems.Center} padding={{ y: 0.5 }} fullWidth borderBottom>
      <Layout margin={{ x: 1 }} className="enforcement-header">
        <Icon asset={open ? SVGAsset.AngleDown : SVGAsset.AngleRight} />
      </Layout>
      <Layout margin={{ right: 1 }} className="enforcement-header">
        {!!profileImage ? (
          <Avatar alt="User profile image" src={profileImage} size={30} />
        ) : (
          <Layout margin={{ x: 0.5 }}>
            <Icon asset={SVGAsset.QuestionMark} />
          </Layout>
        )}
      </Layout>
      <Layout margin={{ x: 1 }} className="enforcement-header">
        <CoreText bold>{targetUserName}</CoreText>
      </Layout>
      <Layout margin={{ x: 1 }} flexGrow={1} className="enforcement-header">
        {content} / {reason}
      </Layout>
      {!!duration && lengthElement}
      <Layout flexGrow={2} />
      <Layout margin={{ x: 2 }}>{createdAt}</Layout>
    </StyledLayout>
  );
};
