import * as React from "react";

import { AlignContent, Background, CoreLink, CoreText, Display, Layout, StyledLayout } from "twitch-core-ui";

import { Enforcement } from "aegis/models";
import { EnforcementCard } from "../enforcement-card";

import "./styles.scss";

export interface Props {
  enforcements?: Enforcement[];
  total: number;
}

export const EnforcementResults: React.SFC<Props> = ({ enforcements, total }) => {
  const [expandedIDs, updateExpandedIDs] = React.useState<string[]>([]);

  const isExpanded = (id: string) => {
    return expandedIDs.includes(id);
  };

  const expand = (id: string) => {
    if (!isExpanded(id)) {
      updateExpandedIDs([...expandedIDs, id]);
    }
  };

  const collapse = (id: string) => {
    const expanded = expandedIDs.filter(eID => eID !== id);
    updateExpandedIDs(expanded);
  };

  const collapseAll = () => {
    updateExpandedIDs([]);
  };

  let enforcementCount;
  if (!!enforcements && enforcements.length !== 0) {
    if (total > 25) {
      enforcementCount = (
        <Layout display={Display.Flex} alignContent={AlignContent.Center}>
          <CoreText>
            Showing {enforcements.length.toString()} of {total} Enforcements
          </CoreText>
          <Layout margin={{ left: 0.5 }}>
            <CoreLink onClick={collapseAll}>Collapse all</CoreLink>
          </Layout>
        </Layout>
      );
    } else {
      enforcementCount = (
        <Layout display={Display.Flex} alignContent={AlignContent.Center}>
          <CoreText>Showing {enforcements.length.toString()} Enforcements</CoreText>
          <Layout margin={{ left: 0.5 }}>
            <CoreLink onClick={collapseAll}>Collapse all</CoreLink>
          </Layout>
        </Layout>
      );
    }
  }
  if (!enforcements) {
    return (
      <CoreText bold key="failed">
        Failed to load Enforcements
      </CoreText>
    );
  }

  const cards =
    enforcements.length === 0 ? (
      <CoreText bold key="none">
        No Enforcements for user
      </CoreText>
    ) : (
      enforcements.map(data => (
        <EnforcementCard
          enforcement={data}
          key={data.id}
          expanded={expandedIDs.includes(data.id)}
          collapse={() => collapse(data.id)}
          expand={() => expand(data.id)}
        />
      ))
    );

  return (
    <StyledLayout
      margin={{ x: 1, y: 1 }}
      padding={{ x: 1, y: 1 }}
      className="enforcement-results"
      border
      background={Background.Base}
    >
      {enforcementCount}
      <Layout>{cards}</Layout>
    </StyledLayout>
  );
};
