import * as React from "react";

import * as classnames from "classnames";

import { channelLink, Stream } from "aegis/models";
import { UserCardLink } from "../user-card/user-link";
import { QuickStrike } from "./quick-strike";

import {
  Avatar,
  BorderRadius,
  CoreImage,
  CoreLink,
  CoreText,
  Display,
  FlexWrap,
  JustifyContent,
  Layout
} from "twitch-core-ui";

import "./styles.scss";

export interface Props {
  stream: Stream;
  grayscale: boolean;
}
export const StreamCard: React.SFC<Props> = ({ stream, grayscale }) => {
  return (
    <Layout padding={1} className="stream-info-card">
      <CoreLink targetBlank linkTo={channelLink(stream.user)}>
        <CoreImage
          className={classnames({
            "stream-info-card__gray_image": grayscale,
            "stream-info-card__banned_image": stream.user.isBanned
          })}
          src={stream.thumbnailURL}
          alt="stream thumbnail"
        />
      </CoreLink>
      <Layout padding={{ top: 1 }} display={Display.Flex} justifyContent={JustifyContent.Between}>
        <Layout display={Display.Flex}>
          <Layout padding={{ right: 0.5 }}>
            <UserCardLink userID={stream.user.id}>
              <CoreLink>
                <Avatar size={36} src={stream.user.profileImage} alt="Avatar" borderRadius={BorderRadius.None} />
              </CoreLink>
            </UserCardLink>
          </Layout>
          <Layout>
            <UserCardLink userID={stream.user.id}>
              <CoreLink>
                <CoreText bold>{stream.user.displayName}</CoreText>
              </CoreLink>
            </UserCardLink>
            <CoreText bold>{stream.title}</CoreText>
            <CoreText>{stream.viewCount} viewers</CoreText>
          </Layout>
        </Layout>
        <Layout>
          <QuickStrike {...stream} />
        </Layout>
      </Layout>
    </Layout>
  );
};

export const StreamsComponent: React.SFC<{ streams: Stream[]; grayscale: boolean }> = ({ streams, grayscale }) => {
  return (
    <Layout display={Display.Flex} flexWrap={FlexWrap.Wrap}>
      {streams.map(stream => {
        return <StreamCard key={stream.user.id} stream={stream} grayscale={grayscale} />;
      })}
    </Layout>
  );
};
