import * as React from "react";

import { Layout, Select, TextAlign } from "twitch-core-ui";

import { Stream } from "aegis/models";
import { QuickStrikeButton, QuickStrikeReasons } from "./quick-strike-button";

const listOfReasons = [
  { name: "Tos Ban Evasion", value: "tos_ban_evasion" },
  { name: "Offensive Username", value: "offensive_username" },
  { name: "Sexual Content", value: "sexual_content" },
  { name: "Harm", value: "harm" },
  { name: "Miscategorized", value: "miscategorized" }
];

export const QuickStrike: React.SFC<Stream> = (props: Stream) => {
  const [selectedReason, changeReason] = React.useState<string>(QuickStrikeReasons.TosBanEvasion);

  return (
    <Layout className="strike-button-dropdown">
      <Select
        onChange={e => {
          changeReason(e.currentTarget.value);
        }}
      >
        {listOfReasons.map(({ name, value }) => {
          return (
            <option key={value} value={value}>
              {name}
            </option>
          );
        })}
      </Select>
      <Layout padding={{ top: 1 }} textAlign={TextAlign.Right}>
        <QuickStrikeButton targetUser={props.user} selectedReason={selectedReason as QuickStrikeReasons}>
          {props.user.isBanned ? `BANNED` : `Strike ${props.user.login}`}
        </QuickStrikeButton>
      </Layout>
    </Layout>
  );
};
