import * as React from "react";

import { observable } from "mobx";
import { observer } from "mobx-react";

import { ImageStore } from "aegis/features/images";
import { ImageDisplay, ImageUploader } from "aegis/features/images";
import { UserInput } from "aegis/functionality/components/user-input";
import { User } from "aegis/models";
import { AlignItems, CoreText, Display, FlexDirection, FontSize, JustifyContent, Layout } from "twitch-core-ui";

@observer
export class ImageUploadFullForm extends React.Component {
  private screenshotStore = new ImageStore();
  @observable user: User | undefined;
  render() {
    return (
      <Layout
        display={Display.Flex}
        alignItems={AlignItems.Center}
        justifyContent={JustifyContent.Center}
        flexDirection={FlexDirection.Column}
        padding={{ top: 2, x: 4 }}
      >
        <CoreText fontSize={FontSize.Size3}>Upload Images</CoreText>
        <Layout fullWidth display={Display.Flex} flexDirection={FlexDirection.Column} alignItems={AlignItems.Start}>
          <Layout margin={{ bottom: 1 }}>
            <UserInput name="upload-target-user" onChange={this.updateTargetUser} />
          </Layout>
          <ImageUploader store={this.screenshotStore} targetUserID={this.user ? this.user.id : undefined} />
        </Layout>
        <Layout padding={{ top: 2 }}>
          <ImageDisplay store={this.screenshotStore} fullComments />
        </Layout>
      </Layout>
    );
  }

  private updateTargetUser = (user?: User) => {
    if (!this.user || (user && this.user.id !== user.id)) {
      this.user = user;
    }
  };
}
