import * as React from "react";

import { mount } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";

import { ImageStore } from "aegis/features/images";
import { StackedModalStore } from "aegis/stores";
import { getNewMockClient } from "aegis/tests/graphql";
import { TestProvider } from "aegis/tests/utils/test-provider";
import { ImageUploader } from "./component";

Enzyme.configure({ adapter: new Adapter() });

// No test for paste actions. ClipboardEvent is not mocked in JSDom,
// mocking it yourself isn't enough as the ClipboardEvent type won't be
// found. JSDOM issue: https://github.com/jsdom/jsdom/issues/1568

describe("Image Uploader", () => {
  let stackedModalStore: StackedModalStore;
  let screenshotStore: ImageStore;
  beforeEach(() => {
    stackedModalStore = new StackedModalStore();
    screenshotStore = new ImageStore();
  });

  it("renders the input box", () => {
    const client = getNewMockClient();
    const wrapper = mount(
      <MockedProvider>
        <TestProvider stackedModalStore={stackedModalStore} client={client}>
          <ImageUploader store={screenshotStore} />
        </TestProvider>
      </MockedProvider>
    );
    expect(wrapper).toMatchSnapshot();
  });
});
