import * as React from "react";
import { Color, CoreLink, CoreText, Display, FontSize, Layout, TextType } from "twitch-core-ui";

export interface PublicProps {
  canReupload: boolean;
  doReupload?: () => void;
}

export const ReuploadHint: React.SFC<PublicProps> = ({ canReupload, doReupload }) => {
  const targetUserHint = (
    <CoreText color={Color.Error} fontSize={FontSize.Size6}>
      <CoreText bold type={TextType.Span}>
        No Target User Selected
      </CoreText>{" "}
      Your images will not be uploaded until you select a user
    </CoreText>
  );
  const reuploadHintWithLink = (
    <CoreText color={Color.Error} fontSize={FontSize.Size6}>
      <CoreText bold type={TextType.Span}>
        Images Not Uploaded
      </CoreText>{" "}
      <CoreLink onClick={doReupload}>Click Here to upload your images now</CoreLink>
    </CoreText>
  );
  return (
    <Layout padding={{ y: 1 }} display={Display.Flex}>
      <Layout>{canReupload ? reuploadHintWithLink : targetUserHint}</Layout>
    </Layout>
  );
};
