import * as stores from "aegis/stores";

export interface APIResponse {
  data?: string;
  error?: string;
}

export const uploadImage = (image: File, callback: (response: APIResponse) => void, targetUserID?: string) => {
  const url = "/api/upload_image";
  const xhr = new XMLHttpRequest();
  const fd = new FormData();
  fd.append("target_user_id", targetUserID ? targetUserID : "");
  fd.append("image", image);
  xhr.open("POST", url);
  xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
  xhr.setRequestHeader("Authorization", `Bearer ${stores.authStore.token}`);
  xhr.onreadystatechange = function() {
    if (xhr.readyState === 4) {
      if (xhr.status === 200) {
        const parsedResponse = JSON.parse(xhr.responseText);
        const imageURL: string = parsedResponse.image_url;
        callback({ data: imageURL });
      } else {
        const errorMessage = JSON.parse(xhr.responseText).message;
        callback({ error: errorMessage });
      }
    }
  };
  xhr.send(fd);
  return;
};
