import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { TestSelectors as AutoSuggestInputTestSelectors } from "aegis/functionality/components/auto-suggest-input";
import { MockLocale } from "aegis/models/mocks";
import { LocalesPickerComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Locales Dropdown", () => {
  it("renders with no locales", () => {
    const wrapper = Enzyme.shallow(<LocalesPickerComponent locales={[]} onSelect={jest.fn()} />);

    expect(wrapper).toBeTruthy();
  });

  it("renders with locales", () => {
    const wrapper = Enzyme.shallow(
      <LocalesPickerComponent locales={[MockLocale(), MockLocale()]} onSelect={jest.fn()} />
    );

    expect(wrapper).toBeTruthy();
  });

  it("invokes onClick when a locale is selected", () => {
    const fn = jest.fn();
    const locale = MockLocale();
    const wrapper = Enzyme.mount(<LocalesPickerComponent locales={[locale]} onSelect={fn} />);

    wrapper
      .find({ "data-test-selector": AutoSuggestInputTestSelectors.SUGGESTION_ITEM })
      .last()
      .simulate("mouseDown");

    expect(fn.mock.calls.length).toBe(1);
    expect(fn.mock.calls[0].pop()).toBe(locale.code);
  });
});
