import * as React from "react";

import gql from "graphql-tag";

import { Query } from "aegis/functionality/apollo-wrapper";
import { Locale } from "aegis/models";
import { LoadingSpinner } from "twitch-core-ui";
import { LocalesPickerComponent, PublicProps } from "./component";

export const FETCH_LOCALES = gql`
  query locales {
    locales {
      code
      display
    }
  }
`;

export type LocalesResponse = {
  locales: Locale[];
};

export class LocaleQuery extends Query<LocalesResponse> {}

export const LocalesPicker: React.SFC<PublicProps> = props => (
  <LocaleQuery displayName="LocalesPicker" query={FETCH_LOCALES} fetchPolicy="cache-first">
    {({ loading, error, data }) => {
      if (loading) {
        return <LoadingSpinner />;
      }
      if (error) {
        console.error("Error occurred fetching locales", error);
      }

      let locales: Locale[] = [];
      if (data) {
        locales = data.locales;
      } else {
        console.error("Invalid data returned. Locales not found");
      }

      locales.sort((a, b) => {
        return a.display.localeCompare(b.display);
      });

      return <LocalesPickerComponent {...props} locales={locales} />;
    }}
  </LocaleQuery>
);
