import * as React from "react";

import { Me as MeModel } from "aegis/models";
import {
  AlignItems,
  Avatar,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  FontSize,
  Layout,
  LineHeight,
  Overflow,
  StyledLayout,
  SVG,
  SVGAsset,
  TextAlign
} from "twitch-core-ui";

import "./styles.scss";

export type MeProps = {
  me: MeModel;
};

export enum TestSelectors {
  Avatar = "me--avatar"
}

export class MeComponent extends React.Component<MeProps> {
  public render() {
    const { me } = this.props;
    return (
      <Layout
        display={Display.Flex}
        flexWrap={FlexWrap.NoWrap}
        alignItems={AlignItems.Center}
        flexGrow={1}
        padding={{ right: 1 }}
        className="top-nav-user-menu"
        fullHeight
      >
        <Layout margin={{ x: 1 }} flexShrink={0}>
          {me.admin && (
            <Avatar size={30} src={me.admin.avatarURL} alt="Avatar" data-test-selector={TestSelectors.Avatar} />
          )}
        </Layout>
        <Layout overflow={Overflow.Hidden} flexGrow={1} flexShrink={1} flexDirection={FlexDirection.Column}>
          <StyledLayout textAlign={TextAlign.Left} color={Color.Overlay} fontSize={FontSize.Size5}>
            <CoreText lineHeight={LineHeight.Heading}>{me.fullName}</CoreText>
          </StyledLayout>
        </Layout>
        <StyledLayout
          display={Display.Flex}
          flexShrink={0}
          color={Color.Overlay}
          data-a-target="top-nav-dropdown-arrow"
        >
          <SVG asset={SVGAsset.GlyphArrDown} />
        </StyledLayout>
      </Layout>
    );
  }
}
