import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockMe } from "aegis/models/mocks";
import { mockSuccessResponse } from "aegis/tests/apollo";
import { mountWithGraphQLData } from "aegis/tests/graphql";
import { LoadingSpinner } from "twitch-core-ui";
import { MeComponent } from "./component";
import { Me } from "./container";
import { FETCH_ME } from "./container";

Enzyme.configure({ adapter: new Adapter() });

const mockMeData = {
  data: {
    me: MockMe()
  }
};

const mockedMe = mockSuccessResponse(FETCH_ME, {}, mockMeData);
describe("Me", () => {
  it("renders loading spinner when loading", async () => {
    const wrapper = await mountWithGraphQLData(<Me />, []);
    expect(wrapper.find(LoadingSpinner)).toBeTruthy();
  });

  it("renders card when loaded", async () => {
    const wrapper = await mountWithGraphQLData(<Me />, [mockedMe]);
    expect(wrapper.find(MeComponent)).toBeTruthy();
  });
});
