import * as React from "react";

import { TranslateButton } from "aegis/features/translate";
import { action, observable } from "mobx";
import { observer } from "mobx-react";
import {
  Button,
  ButtonType,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextAlign
} from "twitch-core-ui";
import { MessageLog, Props } from "../..";
import { Message } from "../../models";

export enum TestSelectors {
  ShowMoreButton = "collapsible-message-log--show-more-button",
  MessageEntries = "collapsible-message-log--message-entries",
  HighlightedEntries = "collapsible-message-log--higlight-message-entries"
}

@observer
export class CollapsibleMessageLog extends React.Component<Props & { messageLogSummary?: Message[] }, {}> {
  @observable private showMore: boolean = false;

  public render() {
    let { entries } = this.props;
    const { highlights, messageLogSummary } = this.props;

    let buttonText = "";

    if (entries.length > 5) {
      if (!this.showMore) {
        entries = entries.slice(0, 5);
        buttonText = "Show More";
      } else {
        entries = entries;
        buttonText = "Show Less";
      }
    }

    const buttons = buttonText && (
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        justifyContent={JustifyContent.Between}
        margin={{ top: 0.5 }}
      >
        <Layout />
        <Layout margin={{ x: 0.5 }} padding={{ x: 2 }} textAlign={TextAlign.Center}>
          <Button
            data-track-click="collapsible-message-log-show-more"
            onClick={this.toggleShowMore}
            data-test-selector={TestSelectors.ShowMoreButton}
            type={ButtonType.Text}
          >
            {buttonText}
          </Button>
        </Layout>
        <Layout margin={{ x: 0.5 }} textAlign={TextAlign.Right}>
          <TranslateButton
            type={ButtonType.Hollow}
            label="Translate All"
            for={entries
              .map(
                message =>
                  `#${message.target && message.target.displayName + " - "}${message.from &&
                    message.from.displayName}: ${message.body}`
              )
              .join("\n")}
          />
        </Layout>
      </Layout>
    );

    return (
      <div>
        {messageLogSummary &&
          messageLogSummary.length > 0 && (
            <>
              <CoreText>Reported Messages</CoreText>
              <MessageLog
                {...this.props}
                entries={messageLogSummary}
                highlights={undefined}
                data-test-selector={TestSelectors.HighlightedEntries}
              />
              <CoreText> Related Messages</CoreText>
            </>
          )}
        <MessageLog
          {...this.props}
          entries={entries}
          highlights={highlights}
          data-test-selector={TestSelectors.MessageEntries}
        />
        {buttons}
      </div>
    );
  }

  @action
  private toggleShowMore = () => {
    this.showMore = !this.showMore;
  };
}
