import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MessageEmote } from "../models";
import { EmoteText } from "./index";

Enzyme.configure({ adapter: new Adapter() });

it("Handles unicode", () => {
  const testCase = "😊 Kappa 123";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 2,
      end: 6
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles strings with no emotes", () => {
  const testCase = "123";
  const testEmotes: MessageEmote[] = [];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles strings with only emotes", () => {
  const testCase = "Kappa";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 0,
      end: 4
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles strings starting with an emote", () => {
  const testCase = "Kappa and some text";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 0,
      end: 4
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles strings ending with an emote", () => {
  const testCase = "Some text and Kappa";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 14,
      end: 18
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles /me messages", () => {
  const testCase = "\u0001ACTION Kappa\u0001";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 0,
      end: 4
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});

it("Handles more than one emote and multiples of each emote", () => {
  const testCase = "testing Kappa PogChamp 123 PogChamp Kappa";
  const testEmotes: MessageEmote[] = [
    {
      emote: {
        id: "25"
      },
      start: 8,
      end: 12
    },
    {
      emote: {
        id: "25"
      },
      start: 36,
      end: 40
    },
    {
      emote: {
        id: "88"
      },
      start: 14,
      end: 21
    },
    {
      emote: {
        id: "88"
      },
      start: 27,
      end: 34
    }
  ];
  const wrapper = Enzyme.shallow(<EmoteText emotes={testEmotes} text={testCase} />);
  expect(wrapper).toMatchSnapshot();
});
