import { Message } from "aegis/features/messages";
import { PagedResponse } from "aegis/functionality/models";
import { MockUser } from "aegis/models/mocks";

export const fakeMessage: Message = {
  id: "b7ca8da9-a22d-4e9f-8559-e85470a120b7",
  sentTimestamp: "1527624440267",
  type: "privmsg",
  from: MockUser({ id: "fromUser" }),
  target: MockUser({ id: "targetUser" }),
  emotes: [
    {
      emote: {
        id: "64138"
      },
      start: 10,
      end: 18
    },
    {
      emote: {
        id: "111700"
      },
      start: 20,
      end: 28
    }
  ],
  badges: [
    {
      title: "Moderator",
      imageURL: "https://twitch-chat-badges-staging.s3.amazonaws.com/badge-3267646d-33f0-4b17-b3df-f923a41db1d0-1.png"
    }
  ],
  isDeleted: false,
  body: "Good Game SeemsGood DatSheffy"
};
export const MockMessage = (overrides?: Partial<Message>): Message => {
  return {
    ...fakeMessage,
    ...overrides
  };
};

export function pagedResponseWithNMessages(n: number): PagedResponse<Message> {
  return {
    edges: Array.from(Array(n).keys()).map(id => {
      return { node: { ...fakeMessage, id: `${id}` }, cursor: "" };
    }),
    pageInfo: {
      startCursor: "{}",
      endCursor: "{}",
      hasNextPage: true,
      hasPreviousPage: false
    }
  };
}

export function ResponseWithNTwitchWhisperMessages(n: number): Message[] {
  return Array.from(Array(n).keys()).map(id => {
    return { ...fakeMessage, id: `${id}` };
  });
}
