import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { ChangeUsersComponent, PartnerActions, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupShallow = (overrides?: Partial<Props>) => {
  return Enzyme.shallow(<ChangeUsersComponent updateList={jest.fn()} {...overrides} />);
};

describe("Partner escalations view", () => {
  it("changes state on action select", () => {
    const wrapper = setupShallow();

    let buttonLabel = wrapper
      .find({ "data-test-selector": TestSelectors.ActionButton })
      .children()
      .text();

    expect(buttonLabel).toEqual(PartnerActions.BulkAdd);

    wrapper.find({ label: PartnerActions.OneTimeRemove }).simulate("change");

    buttonLabel = wrapper
      .find({ "data-test-selector": TestSelectors.ActionButton })
      .children()
      .text();

    expect(buttonLabel).toEqual(PartnerActions.OneTimeRemove);
  });

  it("shows results", () => {
    const wrapper = setupShallow({ result: { updatePartnerEscalationList: { before: 7, after: 12 } } });

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ResultBefore })
        .children()
        .first()
        .text()
    ).toEqual("Total Before: 7");

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.ResultAfter })
        .children()
        .first()
        .text()
    ).toEqual("Total After: 12");
  });
});
