import * as React from "react";

import { apolloErrorHandler } from "aegis/functionality/error-notifications";

import { UPDATE_PARTNER_ESCALATION_LIST_QUERY, UpdatePartnerEscalationListMutation, UpdateType } from "../mutations";
import { ChangeUsersComponent } from "./component";

export const ChangeUsers: React.SFC = () => {
  return (
    <UpdatePartnerEscalationListMutation
      mutation={UPDATE_PARTNER_ESCALATION_LIST_QUERY}
      onError={apolloErrorHandler("Failed to update partners escalation list")}
    >
      {(mutation, { data, loading }) => {
        const updateList = (users: string[], type: UpdateType) => {
          mutation({ variables: { input: { loginOrIDs: users, type: type } } });
        };
        return <ChangeUsersComponent disabled={loading} updateList={updateList} result={data} />;
      }}
    </UpdatePartnerEscalationListMutation>
  );
};
