import * as React from "react";

import { CoreText, Layout, TextType } from "twitch-core-ui";

import { QueryProps } from "aegis/pages/partner-escalation-list";
import { ChangeUsers } from "./change-users";
import { EscalationTab, getCurrentTab, PartnerEscalationTabs } from "./tabs";
import { ViewPartnerList } from "./view-list";

export const PartnerEscalation: React.SFC<{ queryProps: QueryProps }> = ({ queryProps }) => {
  const currentTab = getCurrentTab(queryProps.tabID);
  const pageNumber = queryProps.page ? parseInt(queryProps.page, 10) - 1 : undefined;
  return (
    <Layout padding={2}>
      <CoreText type={TextType.H3}>Partner Escalations</CoreText>
      <Layout padding={{ y: 1 }}>
        <PartnerEscalationTabs queryProps={queryProps} />
      </Layout>
      {currentTab === EscalationTab.ChangeUsers && <ChangeUsers />}
      {currentTab === EscalationTab.ViewList && <ViewPartnerList pageNumber={pageNumber} />}
    </Layout>
  );
};
