import gql from "graphql-tag";
import { Mutation } from "react-apollo";

export const UPDATE_PARTNER_ESCALATION_LIST_QUERY = gql`
  mutation updatePartnerEscalationList($input: UpdatePartnerEscalationListInput!) {
    updatePartnerEscalationList(input: $input) {
      before
      after
    }
  }
`;

export enum UpdateType {
  Add = "Add",
  Remove = "Remove",
  Replace = "Replace"
}

type UpdatePartnerEscalationListInput = {
  input: {
    loginOrIDs: string[];
    type: string;
  };
};

export type UpdatePartnerEscalationListResponse = {
  updatePartnerEscalationList: {
    before: number;
    after: number;
  };
};

export class UpdatePartnerEscalationListMutation extends Mutation<
  UpdatePartnerEscalationListResponse,
  UpdatePartnerEscalationListInput
> {}
