import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { Router } from "react-router-dom";

import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";

import { mountWithGraphQLDataAndClient } from "aegis/tests/graphql";
import { PublicProps, TestSelectors, ViewPartnerListComponentWrapper } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const defaultPropsGenerator: () => PublicProps = () => {
  return {
    users: [
      { id: "19571641", login: "ninja", source: "bulk", dateAdded: "1/21/2019" },
      { id: "146593057", login: "theo", source: "bulk", dateAdded: "1/23/2019" },
      { id: "26301881", login: "sodapoppin", source: "one-time", dateAdded: "1/27/2019" },
      { id: "39141793", login: "xangold", source: "bulk", dateAdded: "1/28/2019" }
    ],
    total: 4,
    totalPages: 1,
    currentPage: 1,
    match: {},
    location: {},
    history: []
  };
};

const setupMount = async (overrides?: Partial<PublicProps>) => {
  const props = defaultPropsGenerator();
  const component = (
    <Router history={createHistory()}>
      <ViewPartnerListComponentWrapper {...props} {...overrides} />
    </Router>
  );
  const data = await mountWithGraphQLDataAndClient(component, []);
  return data.wrapper;
};

describe("Partner escalations view", () => {
  it("renders correct count", async () => {
    const wrapper = await setupMount();

    const recordLabel = wrapper
      .find({ "data-test-selector": TestSelectors.RecordCount })
      .children()
      .text();

    expect(recordLabel).toBe("4 Total Records");
  });

  it("renders with no users", async () => {
    const wrapper = await setupMount({ users: [] });

    expect(wrapper.find({ "data-test-selector": TestSelectors.PartnerTableRow })).toHaveLength(0);
  });

  it("renders users as table rows", async () => {
    const wrapper = await setupMount();

    expect(wrapper.find({ "data-test-selector": TestSelectors.PartnerTableRow }).hostNodes()).toHaveLength(4);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.LoginCell })
        .first()
        .children()
        .text()
    ).toBe("ninja");
  });
});
