import * as React from "react";

import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";
import { apolloErrorHandler } from "aegis/functionality/error-notifications";
import { Button, ButtonType, SVGAsset } from "twitch-core-ui";
import { UPDATE_PARTNER_ESCALATION_LIST_QUERY, UpdatePartnerEscalationListMutation, UpdateType } from "../mutations";
import { EscalatedPartners } from "./component";

export interface Props {
  user: EscalatedPartners;
}

export const RemoveFromListButton: React.SFC<Props> = ({ user }) => {
  return (
    <UpdatePartnerEscalationListMutation
      mutation={UPDATE_PARTNER_ESCALATION_LIST_QUERY}
      onError={apolloErrorHandler(`Failed to remove ${user.id} from list`)}
    >
      {(mutation, { data, loading }) => {
        const removeUser = () => {
          mutation({ variables: { input: { loginOrIDs: [user.id], type: UpdateType.Remove } } });
        };
        return (
          <WithConfirmationModal
            title={`Removing escalated partner`}
            body={`Are you sure to remove ${user.login} from escalated partner list?`}
            confirmLabelOverride="Remove"
            onConfirm={removeUser}
          >
            {confirm => <RemoveFromListButtonComponent loading={loading} success={!!data} onClick={confirm} />}
          </WithConfirmationModal>
        );
      }}
    </UpdatePartnerEscalationListMutation>
  );
};

const RemoveFromListButtonComponent: React.SFC<{ loading: boolean; success: boolean; onClick: () => void }> = ({
  loading,
  success,
  onClick
}) => {
  return (
    <Button
      disabled={loading}
      type={success ? ButtonType.Success : ButtonType.Default}
      icon={SVGAsset.RemoveTag}
      onClick={onClick}
    />
  );
};
