import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockReportContent } from "aegis/models/mocks/report";
import { ReportContentDropdownComponent, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Report Content Dropdown", () => {
  it("renders with no content", () => {
    const wrapper = Enzyme.shallow(<ReportContentDropdownComponent onSelect={jest.fn()} contents={[]} />);

    expect(wrapper).toBeTruthy();
  });

  it("renders with contents", () => {
    const wrapper = Enzyme.shallow(
      <ReportContentDropdownComponent onSelect={jest.fn()} contents={[MockReportContent()]} />
    );

    expect(wrapper).toBeTruthy();
  });

  it("calls onSelect on selecting", () => {
    const fn = jest.fn();
    const content = MockReportContent();
    const wrapper = Enzyme.mount(<ReportContentDropdownComponent onSelect={fn} contents={[content]} />);

    wrapper
      .find({ "data-test-selector": TestSelectors.Toggle })
      .hostNodes()
      .simulate("click");
    wrapper
      .find({ "data-test-selector": TestSelectors.Option })
      .last()
      .simulate("click");

    expect(fn.mock.calls.length).toBe(1);
    expect(fn.mock.calls.pop()![0]).toBe(content);
  });
});
