import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { ReportContent, ReportContentCode } from "aegis/models";
import { Color, CoreText, LoadingSpinner } from "twitch-core-ui";
import { ReportContentDropdownComponent } from "./component";

export const FETCH_REPORT_CONTENTS = gql`
  query reportContents {
    reportContents {
      ...ReportContentFields
    }
  }

  ${Fragments.ReportContentFields}
`;

export interface Props {
  defaultContentCode?: ReportContentCode;
  onSelect: (code: ReportContent) => void;
}

export type ReportContentsResponse = {
  reportContents: ReportContent[];
};

export class ReportContentsQuery extends Query<ReportContentsResponse> {}

// TODO move this out and share it
export class ReportContentDropdown extends React.Component<Props> {
  public render() {
    const { defaultContentCode, onSelect } = this.props;

    return (
      <ReportContentsQuery displayName="ReportContentDropdown" query={FETCH_REPORT_CONTENTS} fetchPolicy="cache-first">
        {({ loading, error, data }) => {
          if (loading) {
            return <LoadingSpinner />;
          }
          if (error || !data) {
            console.error("Error occurred fetching report contents", error);
            return <CoreText color={Color.Error}>Error fetching Report Contents</CoreText>;
          }

          const contents: ReportContent[] = data.reportContents;
          contents.sort((a, b) => {
            return a.displayName.localeCompare(b.displayName);
          });

          return (
            <ReportContentDropdownComponent
              defaultContentCode={defaultContentCode}
              contents={contents}
              onSelect={onSelect}
            />
          );
        }}
      </ReportContentsQuery>
    );
  }
}
