import * as React from "react";

import { inject, observer, Provider } from "mobx-react";

import { ImageStore } from "aegis/features/images";
import { ReportView, ReportViewType } from "aegis/features/report-view";
import { Report } from "aegis/features/reports";
import { ReportStoreProps } from "aegis/stores";

import { CoreText, Display, FlexDirection, Layout, TextType } from "twitch-core-ui";

import "./styles.scss";

export interface Props {
  report: Report;
}

@inject("reportStore")
@observer
export class ReportDetailPageView extends React.Component<Props & ReportStoreProps> {
  private screenshotStore = new ImageStore();

  componentDidMount() {
    const { report, reportStore } = this.props;
    reportStore!.clear();
    reportStore!.setFocusedID(report.id);
    reportStore!.expand(report.id);
  }

  componentWillUnmount() {
    const { reportStore } = this.props;
    reportStore!.clear();
  }

  render() {
    const { report, reportStore } = this.props;
    return (
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column} fullWidth padding={{ bottom: 2 }}>
        <Layout padding={2} flexGrow={0} className="report-title">
          <CoreText type={TextType.H2}>Report Details</CoreText>
        </Layout>
        <Layout className="report-detail">
          <Provider screenshotStore={this.screenshotStore}>
            {/* TODO this should be using the standalone view that report search uses*/}
            <ReportView viewType={ReportViewType.Main} report={report} reportStore={reportStore!} disableExpand />
          </Provider>
        </Layout>
      </Layout>
    );
  }
}
