import * as React from "react";

import gql from "graphql-tag";

import { Report } from "aegis/features/reports";
import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { Color, CoreText } from "twitch-core-ui";
import { ReportDetailPageView } from "./component";

export const FETCH_REPORT_QUERY = gql`
  query report($id: ID!) {
    report(id: $id) {
      ...ReportFields
    }
  }
  ${Fragments.ReportFields}
`;

type QueryVals = {
  id: string;
};

type Response = {
  report: Report;
};

export type Props = QueryVals;

export class ReportDetailQuery extends Query<Response, QueryVals> {}

export const ReportDetail: React.SFC<Props> = ({ id }) => {
  return (
    <ReportDetailQuery
      displayName="ReportDetail"
      query={FETCH_REPORT_QUERY}
      variables={{
        id: id
      }}
    >
      {({ loading, error, data }) => {
        if (loading) {
          return <div>loading</div>;
        }
        if (error) {
          console.error(error);
          return <CoreText color={Color.Error}>An error occurred. {error.message}</CoreText>;
        }
        if (!data) {
          return <CoreText color={Color.Error}>Failed to load report.</CoreText>;
        }

        return <ReportDetailPageView report={data.report} />;
      }}
    </ReportDetailQuery>
  );
};
