import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockReportReason } from "aegis/models/mocks/report";
import { ReportReasonDropdownComponent, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Report Reason Dropdown", () => {
  it("renders with no reason", () => {
    const wrapper = Enzyme.shallow(<ReportReasonDropdownComponent onSelect={jest.fn()} reasons={[]} />);

    expect(wrapper).toBeTruthy();
  });

  it("renders with reasons", () => {
    const wrapper = Enzyme.shallow(
      <ReportReasonDropdownComponent onSelect={jest.fn()} reasons={[MockReportReason()]} />
    );

    expect(wrapper).toBeTruthy();
  });

  it("calls onSelect on selecting", () => {
    const fn = jest.fn();
    const reason = MockReportReason();
    const wrapper = Enzyme.mount(<ReportReasonDropdownComponent onSelect={fn} reasons={[reason]} />);

    wrapper
      .find({ "data-test-selector": TestSelectors.Toggle })
      .hostNodes()
      .simulate("click");
    wrapper
      .find({ "data-test-selector": TestSelectors.Option })
      .last()
      .simulate("click");

    expect(fn.mock.calls.length).toBe(1);
    expect(fn.mock.calls.pop()![0]).toBe(reason);
  });
});
