import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { ReportReason, ReportReasonCode } from "aegis/models";
import { Color, CoreText, LoadingSpinner } from "twitch-core-ui";
import { ReportReasonDropdownComponent } from "./component";

export const FETCH_REPORT_REASONS = gql`
  query reportReasons {
    reportReasons {
      ...ReportReasonFields
    }
  }

  ${Fragments.ReportReasonFields}
`;

export interface Props {
  defaultReasonCode?: ReportReasonCode;
  onSelect: (code: ReportReason) => void;
}

export type ReportReasonsResponse = {
  reportReasons: ReportReason[];
};

export class ReportReasonsQuery extends Query<ReportReasonsResponse> {}

export class ReportReasonDropdown extends React.Component<Props> {
  public render() {
    const { defaultReasonCode, onSelect } = this.props;

    return (
      <ReportReasonsQuery displayName="ReportReasonDropdown" query={FETCH_REPORT_REASONS} fetchPolicy="cache-first">
        {({ loading, error, data }) => {
          if (loading) {
            return <LoadingSpinner />;
          }
          if (error || !data) {
            console.error("Error occurred fetching report reasons", error);
            return <CoreText color={Color.Error}>Error fetching Report Reasons</CoreText>;
          }

          const reasons: ReportReason[] = data.reportReasons;
          reasons.sort((a, b) => {
            return a.displayName.localeCompare(b.displayName);
          });

          return (
            <ReportReasonDropdownComponent
              defaultReasonCode={defaultReasonCode}
              reasons={reasons}
              onSelect={onSelect}
            />
          );
        }}
      </ReportReasonsQuery>
    );
  }
}
