import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { Report } from "aegis/features/reports/models";
import * as Fragments from "aegis/fragments";

export const ASSIGN_REPORT_TO_ADMIN = gql`
  mutation assignReportToAdmin($input: AssignReportToAdminInput!) {
    assignReportToAdmin(input: $input) {
      report {
        ...ReportFields
      }
    }
  }
  ${Fragments.ReportFields}
`;

export type AssignReportToAdminInput = {
  input: {
    id: string;
    adminLdap?: string;
  };
};

export type AssignReportToAdminResponse = {
  assignReportToAdmin: {
    report: Report;
  };
};

export class AssignReportToAdminMutation extends Mutation<AssignReportToAdminResponse, AssignReportToAdminInput> {}
