import * as React from "react";

import { createContext } from "aegis/functionality/utils/contrib/twilight/context";

export interface ReportMutationContext {
  createComment: (comment: string, ancestorName: string, onComplete: () => void) => void;
}

const mutationsInitValues: ReportMutationContext = {
  createComment: () => undefined
};

export const { InnerProvider: ReportMutationsInnerProvider, withContext: withReportMutationContext } = createContext<
  ReportMutationContext
>("ReportMutationContext", mutationsInitValues);

export class ReportMutationContextProvider extends React.Component<ReportMutationContext> {
  public render() {
    return <ReportMutationsInnerProvider value={this.props}>{this.props.children}</ReportMutationsInnerProvider>;
  }
}

export function reportMutationContextMapper(context: ReportMutationContext): ReportMutationContext {
  return context;
}
