import gql from "graphql-tag";

import { Comment } from "aegis/features/reports";
import { CommentFields } from "aegis/fragments";

export const MAKE_COMMENT = gql`
  mutation createReportComment($input: CreateReportCommentInput!) {
    createReportComment(input: $input) {
      reportComment {
        ...CommentFields
      }
    }
  }
  ${CommentFields}
`;

export type CreateReportCommentInput = {
  input: {
    reportID: string;
    comment: string;
  };
};

export type CreateReportCommentResponse = {
  createReportComment: {
    reportComment: Comment;
  };
};
