import * as React from "react";

import {
  AlignContent,
  AlignItems,
  Background,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  Pill,
  StyledLayout,
  Table,
  TableBody,
  TableCell,
  TableHeader,
  TableHeading,
  TableRow,
  TextType
} from "twitch-core-ui";

import { Report } from "aegis/features/reports";

import { getHoldMinutes } from "../../report-banner/component";
import "./styles.scss";

export const REPORT_AUDIT_MODAL_TEST_SELECTOR = "report-audit-modal-header-test-selector";

interface Props {
  report: Report;
}
export class ReportAuditModal extends React.Component<Props> {
  public render() {
    const { report } = this.props;

    const reportAudits = report.audits.map((reportAudit, index) => {
      let extraInfo = null;
      if (reportAudit.action === "hold" && reportAudit.hold) {
        extraInfo = (
          <CoreText lines={2}>
            {`ID: ${reportAudit.hold.id}`}
            <br />
            {`Held for ${getHoldMinutes(reportAudit.hold)}m`}
          </CoreText>
        );
      }
      if (reportAudit.action === "autoresolve" && reportAudit.autoResolveID) {
        extraInfo = "ID: " + reportAudit.autoResolveID;
      }
      return (
        <TableRow key={index}>
          <TableCell>{new Date(reportAudit.createdAt).toDisplayFormat()}</TableCell>
          <TableCell>{reportAudit.action ? reportAudit.action : null}</TableCell>
          <TableCell>{reportAudit.actionBy ? reportAudit.actionBy.ldap : null}</TableCell>
          <TableCell>{reportAudit.diff ? reportAudit.diff : null}</TableCell>
          <TableCell>{extraInfo}</TableCell>
        </TableRow>
      );
    });

    // Reversed afterwards, as reversing report.audits persists across the tree it received from (lol)
    reportAudits.reverse();

    return (
      <Layout className="report-audits-modal" alignContent={AlignContent.Center} alignItems={AlignItems.Center}>
        <StyledLayout background={Background.Base} fullHeight={true} alignContent={AlignContent.Center} padding={1}>
          <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
            <Layout>
              <CoreText type={TextType.H3} data-test-selector={REPORT_AUDIT_MODAL_TEST_SELECTOR}>
                Audit History for Report {report.id}
              </CoreText>
            </Layout>
            <Layout>
              <Pill label="Beta" />
            </Layout>
          </Layout>
          <Layout padding={{ y: 1 }}>
            <Table>
              <TableHeader>
                <TableHeading label="Date" />
                <TableHeading label="Action" />
                <TableHeading label="Action By" />
                <TableHeading label="Diff" />
                <TableHeading label="Additional context" />
              </TableHeader>
              <TableBody>{reportAudits}</TableBody>
            </Table>
          </Layout>
        </StyledLayout>
      </Layout>
    );
  }
}
