import * as React from "react";

import { action, observable } from "mobx";
import { observer } from "mobx-react";

import { ButtonIcon, ButtonIconType, SVGAsset, Tooltip, TooltipAlign } from "twitch-core-ui";

import { Report } from "aegis/features/reports";
import { PortalModal } from "aegis/functionality/components/portal-modal";
import { ReportAuditModal } from "./audits-modal";

export interface Props {
  report: Report;
}

@observer
export class ReportAuditModalButton extends React.Component<Props> {
  @observable auditModalVisible: boolean = false;

  get auditModal(): JSX.Element {
    return (
      <PortalModal
        onClose={() => {
          this.auditModalVisible = false;
        }}
      >
        <ReportAuditModal report={this.props.report} />
      </PortalModal>
    );
  }

  public render() {
    return (
      <Tooltip align={TooltipAlign.Right} label="See all audits on this report">
        {this.auditModalVisible && this.auditModal}
        <ButtonIcon
          data-track-click="audit-history-button-click"
          onClick={this.onClick}
          ariaLabel="Open Audit history modal"
          icon={SVGAsset.Document}
          type={ButtonIconType.Secondary}
        />
      </Tooltip>
    );
  }

  @action
  private onClick = (event: React.MouseEvent) => {
    event.stopPropagation();
    this.auditModalVisible = true;
  };
}
