import * as React from "react";

import gql from "graphql-tag";
import { Mutation } from "react-apollo";

import { Report } from "aegis/features/reports";
import * as Fragments from "aegis/fragments";

import { ReportActionContext, withReportActionContext } from "../../context";
import { Props as ComponentProps, ReportBannerComponent } from "./component";

export const disableReportHold = gql`
  mutation disableReportHold($input: DisableReportHoldInput!) {
    disableReportHold(input: $input) {
      report {
        ...ReportFields
      }
    }
  }
  ${Fragments.ReportFields}
`;

type DisableReportHoldInput = {
  input: {
    reportID: string;
  };
};

type DisableReportHoldResponse = {
  disableReportHold: {
    report: Report;
  };
};

export type Props = ComponentProps & ReportActionContext;

export class CancelHoldMutation extends Mutation<DisableReportHoldResponse, DisableReportHoldInput> {}

export const ReportBannerContainer: React.SFC<Props> = ({ report, onCancelHold }) => {
  return (
    <CancelHoldMutation
      mutation={disableReportHold}
      onCompleted={() => {
        if (onCancelHold) {
          onCancelHold();
        }
      }}
    >
      {disableReportHoldQuery => {
        const disableHold = () => {
          disableReportHoldQuery({ variables: { input: { reportID: report.id } } });
        };

        return <ReportBannerComponent report={report} disableHold={disableHold} />;
      }}
    </CancelHoldMutation>
  );
};

function mapContextToProps(context: ReportActionContext): ReportActionContext {
  return context;
}

export const ReportBanner = withReportActionContext<ReportActionContext, ComponentProps>(mapContextToProps)(
  ReportBannerContainer
);
