import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser, MockUser } from "aegis/models/mocks";

import { Props, StreamEmbedComponent, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupShallow = (override?: Partial<Props>) => {
  const props: Props = {
    user: MockDetailedUser(),
    ...override
  };
  return Enzyme.shallow(<StreamEmbedComponent {...props} />);
};

describe("StreamEmbedComponent", () => {
  it("renders correct uptime", () => {
    const title = "title123";
    const wrapper = setupShallow({
      user: MockDetailedUser({
        stream: {
          duration: 3690,
          title: title,
          viewCount: 0,
          thumbnailURL: "thumnailURL",
          user: MockUser()
        }
      })
    });

    expect(wrapper.find({ "data-test-selector": TestSelectors.Uptime }).prop("value")).toEqual("1h 1m 30s");
  });
});
