import * as React from "react";

import { CoreText, Placeholder } from "twitch-core-ui";

import { errorNotification, ErrorNotificationOptions } from "aegis/functionality/error-notifications";

import { ArrowIconType, CollapsibleCard } from "aegis/functionality/components/collapsible";
import { DETAILED_USER_QUERY, DetailedUserQuery } from "../user-metadata";
import { StreamEmbedComponent } from "./component";

export interface Props {
  id: string;
  onClose?: () => void;
  roundedCorner?: boolean;
}

export const StreamEmbed: React.SFC<Props> = ({ id, onClose }) => {
  return (
    <DetailedUserQuery displayName="StreamEmbed" query={DETAILED_USER_QUERY} variables={{ id }}>
      {({ loading, data, error }) => {
        if (loading) {
          return <CollapsibleCard title={<Placeholder width={50} />} defaultClosed={true} />;
        }
        if (error || !data || !data.user) {
          const opts: ErrorNotificationOptions = error ? { error } : { error: "user was null" };
          errorNotification("Error fetching detailed user information", opts);
          return null;
        }
        const title = <CoreText bold>Stream Preview</CoreText>;
        return (
          <CollapsibleCard
            roundedCorner
            arrowIconType={ArrowIconType.Angle}
            title={title}
            defaultClosed={!data.user.stream}
          >
            <StreamEmbedComponent roundedBottom user={data.user} onClose={onClose} />
          </CollapsibleCard>
        );
      }}
    </DetailedUserQuery>
  );
};
