import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockEnforcement, MockSuspension, MockWarning } from "aegis/models/mocks/enforcements";
import { LatestEnforcementComponent } from "./component";
import { TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("Latest Enforcement", () => {
  it("Renders when give a suspension", () => {
    const id = "12345";
    const enforcement = MockEnforcement({
      suspension: MockSuspension({
        id: id
      })
    });
    const wrapper = Enzyme.shallow(<LatestEnforcementComponent enforcement={enforcement} />);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.SuspensionEnforcementID })
        .children()
        .text()
    ).toBe(id);
  });
  it("Renders when given a warning", () => {
    const id = "12345";
    const enforcement = MockEnforcement({
      warning: MockWarning({
        id: id
      })
    });
    const wrapper = Enzyme.shallow(<LatestEnforcementComponent enforcement={enforcement} />);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.WarningEnforcementID })
        .children()
        .text()
    ).toBe(id);
  });
  it("Renders nothing when no suspension or warning", () => {
    const enforcement = MockEnforcement({
      warning: undefined,
      suspension: undefined
    });
    const wrapper = Enzyme.shallow(<LatestEnforcementComponent enforcement={enforcement} />);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.NoEnforcement })
        .children()
        .text()
    ).toBe("No enforcements found for user");
  });
});
