import { Suspension, Warning } from "aegis/models";
import * as React from "react";
import { AlignItems, CoreLink, CoreText, Display, FlexDirection, Layout } from "twitch-core-ui";

export interface Props {
  enforcement?: {
    warning?: Warning;
    suspension?: Suspension;
  };
}

export enum TestSelectors {
  SuspensionEnforcementID = "suspension-enforcement-id",
  WarningEnforcementID = "warning-enforcement-id",
  NoEnforcement = "no-enforcement"
}

export const LatestEnforcementComponent: React.SFC<Props> = ({ enforcement }) => {
  if (!!enforcement && !!enforcement.suspension) {
    return (
      <Layout
        margin={{ top: 0.5, left: 2 }}
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        alignItems={AlignItems.Start}
      >
        <Layout margin={{ right: 0.5 }}>
          <CoreText>Enforcement ID:</CoreText>
        </Layout>
        <Layout margin={{ right: 1 }} data-test-selector={TestSelectors.SuspensionEnforcementID}>
          {enforcement.suspension.id}
        </Layout>
        <Layout margin={{ right: 0.5 }}>
          <CoreLink
            data-track-click="report-card-user-view-most-recent-enforcement"
            targetBlank
            linkTo={`/enforcementsearch?user=${enforcement.suspension.targetUserID}`}
          >
            <CoreText>View All</CoreText>
          </CoreLink>
        </Layout>
      </Layout>
    );
  } else if (!!enforcement && !!enforcement.warning) {
    return (
      <Layout
        margin={{ top: 0.5, left: 2 }}
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        alignItems={AlignItems.Start}
      >
        <Layout margin={{ right: 0.5 }}>
          <CoreText>Enforcement ID:</CoreText>
        </Layout>
        <Layout margin={{ right: 1 }} data-test-selector={TestSelectors.WarningEnforcementID}>
          {enforcement.warning.id}
        </Layout>
        <Layout>
          <CoreLink
            data-track-click="report-card-user-view-most-recent-enforcement"
            targetBlank
            linkTo={`/enforcementsearch?user=${enforcement.warning.targetUserID}`}
          >
            <CoreText>View All</CoreText>
          </CoreLink>
        </Layout>
      </Layout>
    );
  } else {
    return <CoreText data-test-selector={TestSelectors.NoEnforcement}>No enforcements found for user</CoreText>;
  }
};
