import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { Enforcement } from "aegis/models";
import { CoreText, Placeholder } from "twitch-core-ui";
import { LatestEnforcementComponent } from "./component";

export interface Response {
  enforcements: {
    enforcements: Enforcement[];
  };
}

export const LATEST_ENFORCEMENT_QUERY = gql`
  query latestEnforcement($user: ID) {
    enforcements(user: $user) {
      enforcements {
        suspension {
          ...SuspensionFields
        }
        warning {
          ...WarningFields
        }
      }
    }
  }
  ${Fragments.SuspensionFields}
  ${Fragments.WarningFields}
`;

export interface InputProps {
  user: string;
}

export class LatestEnforcementQuery extends Query<Response, InputProps> {}

export const LatestEnforcement: React.SFC<InputProps> = ({ user }) => {
  return (
    <LatestEnforcementQuery displayName="LatestEnforcement" query={LATEST_ENFORCEMENT_QUERY} variables={{ user }}>
      {({ loading, data, error }) => {
        if (loading) {
          return <Placeholder width={200} lineCount={1} />;
        }
        if (error) {
          return (
            <CoreText>Error loading latest enforcement: {error ? error.message : "No enforcement found"}</CoreText>
          );
        }
        if (!!data) {
          return <LatestEnforcementComponent enforcement={data.enforcements.enforcements[0]} />;
        }
        return <CoreText>Error loading latest enforcement: No Data</CoreText>;
      }}
    </LatestEnforcementQuery>
  );
};
