import * as React from "react";

import { Report, ReportQueue } from "aegis/features/reports";
import { User } from "aegis/models";
import { Color, CoreText } from "twitch-core-ui";
import { ReportViewType } from "../../models";
import { InvestigativeQueueButtons } from "./investigative-queue-buttons";
import { MainQueueButtons } from "./main-queue-buttons";

export interface PublicProps {
  report: Report;
  viewType: ReportViewType;
  expanded?: boolean;
  onStrike?: (User?: User) => void;
  onResolve?: (report: Report) => void;
  onReassign?: (report: Report) => void;
  onInvestigate?: (report: Report) => void;
  onCancelInvestigate?: (report: Report) => void;
  onHold?: (report: Report) => void;
}

type Props = PublicProps;

export class ReportButtons extends React.Component<Props> {
  public render() {
    const { report, viewType } = this.props;
    if (viewType === ReportViewType.Investigative || report.assignedToQueue === ReportQueue.Investigative) {
      return <InvestigativeQueueButtons report={report} {...this.props} />;
    } else if (viewType === ReportViewType.Main || viewType === ReportViewType.Search) {
      return <MainQueueButtons report={report} {...this.props} />;
    }

    console.error("Unknown view type ", viewType);
    return <CoreText color={Color.Error}>Unable to render buttons. Unknown view type {viewType}</CoreText>;
  }
}
