import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { mockReport } from "aegis/features/report-view/reportMocks";
import { HoldButtonComponent, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupProps = (override?: Partial<Props>): Props => {
  return {
    report: mockReport(),
    createHold: jest.fn(),
    ...override
  };
};

describe("hold dropdown", () => {
  it("calls createHold with selectedHoldLength", () => {
    const props = setupProps();
    const wrapper = Enzyme.shallow(<HoldButtonComponent {...props} />);

    const dropdown = wrapper.find({ "data-test-selector": TestSelectors.holdForm });
    expect(dropdown).toHaveLength(1);
    dropdown.prop("onHoldClicked")();
    expect(props.createHold).toHaveBeenCalledWith(dropdown.prop("selectedHoldLength"));
  });
});
